/*
 * @(#)DMLModelFactory.java  1.0  2006-01-18
 *
 * Copyright (c) 2003 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.hslu.cm.dml;

import ch.hslu.cm.rer.diagram.EntityFigure;
import ch.hslu.cm.rer.diagram.RERAttributeConnector;
import ch.hslu.cm.rer.diagram.RelationshipFigure;
import ch.hslu.cm.rer.model.Entity;
import ch.hslu.cm.rer.model.RERAttribute;
import ch.hslu.cm.rer.model.RelationalERModel;
import ch.hslu.cm.rer.model.Relationship;
import org.jhotdraw.draw.*;
import org.jhotdraw.draw.connector.ChopRectangleConnector;
import org.jhotdraw.draw.connector.StickyRectangleConnector;
import org.jhotdraw.draw.decoration.ArrowTip;
import org.jhotdraw.draw.liner.SlantedLiner;
import org.jhotdraw.draw.locator.BezierLabelLocator;
import org.jhotdraw.xml.DefaultDOMFactory;
/**
 * DMLModelFactory.
 *
 *
 * @author Werner Randelshofer
 * @version 2006-01-18 Created.
 */
public class DMLModelFactory extends DefaultDOMFactory {
    private final static Object[][] classTagArray = {
        { RelationalERModel.class, "ermodel" },
        { RERAttribute.class, "attribute" },
        { Relationship.class, "relation" },
        { Entity.class, "entityType" },
        
        { DMLDiagram.class, "erdiagram" },
        { RelationshipFigure.class, "relationF" },
        { EntityFigure.class, "entityTypeF" },
        { TextFigure.class, "textF" },
        { GroupFigure.class, "g" },
        { TextAreaFigure.class, "ta" },
        
        { RERAttributeConnector.class, "attrConnector" },
        { StickyRectangleConnector.class, "arectConnector" },
        { ChopRectangleConnector.class, "rectConnector" },
        { BezierLabelLocator.class, "polylabelLocator" },
        { SlantedLiner.class, "slantedLiner" },
        { ArrowTip.class, "arrowTip" }
    };
    
    /** Creates a new instance. */
    public DMLModelFactory() {
        for (Object[] o : classTagArray) {
            addStorableClass((String) o[1], (Class) o[0]);
        }
    }
}
